<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\MainController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

//Main files
Route::get('/activities', [MainController::class, 'activities'])->name('activities')->middleware('auth');
 Route::get('/projects', [MainController::class, 'projects'])->name('projects')->middleware('auth');
 Route::get('/partners', [MainController::class, 'partners'])->name('partners')->middleware('auth');
 Route::get('/team', [MainController::class, 'team'])->name('team')->middleware('auth');
 //End of main files
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
